<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <title><?php echo e($document->title); ?></title>

    

    <style>
        body {
            font-family: <?php echo e($document->pdfFont()['font-family']); ?>;
        }

        @page {
            margin: 0px;
        }

        html,
        body {
            margin: 0px;
        }

        <?php if($document->data['pdf']['padding'] ?? null): ?>
            .contentbuilder {
                padding: <?php echo e($document->data['pdf']['padding']); ?>;
            }
        <?php endif; ?>
    </style>

    

    <style>
        <?php if($document->atLeastOneSigned()): ?>
            @font-face {
                font-family: 'Dancing Script';
                font-style: normal;
                font-weight: 400;
                src: url("<?php echo e(public_path('fonts/DancingScript-Regular.ttf')); ?>") format("truetype");
            }

            .font-signature {
                font-family: 'Dancing Script' !important;
            }
        <?php endif; ?>
    </style>

    
    <?php $__currentLoopData = $document->content->forPdf()->usedGoogleFonts(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $font): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <link
            href="https://fonts.googleapis.com/css2?family=<?php echo e(urlencode($font['name'])); ?><?php echo e($font['stylesQueryString']); ?>&display=swap"
            rel="stylesheet" />
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
    <?php if(is_file($iconsPath = public_path('static/contentbuilder/assets/ionicons/css/ionicons.css'))): ?>
        <style>
            <?php echo str_replace('/fonts', public_path('/fonts'), file_get_contents($iconsPath)); ?>

        </style>
    <?php endif; ?>

    
    <?php if(is_file($pdfPath = base_path('resources/css/contentbuilder/pdf.css'))): ?>
        <style type="text/css">
            <?php echo file_get_contents($pdfPath); ?>;
        </style>
    <?php endif; ?>

    <?php if ($__env->exists('documents::custom.pdf-head')) echo $__env->make('documents::custom.pdf-head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>
    <?php if ($__env->exists('documents::custom.pdf-header')) echo $__env->make('documents::custom.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if ($__env->exists('documents::custom.pdf-footer')) echo $__env->make('documents::custom.pdf-footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <main class="contentbuilder">
        <?php echo $document->content->forPdf(); ?>

    </main>
</body>

</html>
<?php /**PATH /home/theboxwe/pipedrive.theboxwebgt.com/modules/Documents/resources/views/pdf.blade.php ENDPATH**/ ?>