<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />

    <?php echo $__env->renderWhen(config('core.favicon_enabled'), 'favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>

    <?php echo $__env->renderWhen($darkMode ?? true, 'core::theme-change', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <script>
        window.Innoclapps = {
            bootingCallbacks: [],
            bootedCallbacks: [],
            booting: function(callback) {
                this.bootingCallbacks.push(callback)
            },
            booted: function(callback) {
                this.bootedCallbacks.push(callback)
            }
        }
    </script>

    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">

    <script src="<?php echo e(\Modules\Core\Facades\Innoclapps::vueSrc()); ?>"></script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>

    <?php echo \Modules\Core\Facades\Innoclapps::viteOutput(); ?>


    <script>
        <?php if(($darkMode ?? true) === true): ?>
            updateTheme();
        <?php endif; ?>

        var config = <?php echo json_encode(\Modules\Core\Application::getDataProvidedToScript(), 15, 512) ?>;
        var lang = <?php echo json_encode(get_generated_lang(app()->getLocale()), 15, 512) ?>;
    </script>

    <?php echo $__env->yieldPushContent('head'); ?>

    <?php if ($__env->exists('custom.includes.head')) echo $__env->make('custom.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>
    <div id="app" v-cloak>
        <?php echo e($slot); ?>


        <teleport to="body">
            <the-float-notifications></the-float-notifications>
        </teleport>
    </div>

    <?php echo $__env->make('core::boot', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        bootApplication(config, Innoclapps.bootingCallbacks, Innoclapps.bootedCallbacks);
    </script>
</body>

</html>
<?php /**PATH /home/theboxwe/pipedrive.theboxwebgt.com/modules/Core/resources/views/components/layouts/guest.blade.php ENDPATH**/ ?>