<?php if(Auth::user()->isSuperAdmin() &&
        app()->isProduction() &&
        collect(config('filesystems.links'))->filter(fn($link, $target) => !is_link($link))->isNotEmpty()): ?>
    <?php $__currentLoopData = config('filesystems.links'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link => $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(is_link($link)): ?>
            <?php continue; ?>
        <?php endif; ?>

        <i-alert variant="danger" class="rounded-none">
            <i-alert-body>
                <p>
                    The <span class="font-semibold"><?php echo e($link); ?></span> filesystem link does not exist.
                </p>

                <p class="mt-2">
                    If you recently moved your installation to another server or location, the
                    <code><span
                            class="font-semibold"><?php echo e(str_replace(base_path() . DIRECTORY_SEPARATOR, '', $link)); ?></span></code>
                    directory should not be copied into your new location.
                </p>

                <p class="mt-2">
                    After ensuring the directory is not copied, go to <span class="font-semibold">Settings -> System ->
                        Tools</span>
                    and run the <span class="font-semibold">storage-link</span> command.
                </p>

            </i-alert-body>
        </i-alert>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php /**PATH /home/theboxwe/pipedrive.theboxwebgt.com/modules/Core/resources/views/warnings/storage-links.blade.php ENDPATH**/ ?>